import pandas as pd   
from sklearn.preprocessing import LabelEncoder
import pickle
from decision_company import read_csv_file, encoder_instance, encode_column

# Load the dataset    
credit_customers = read_csv_file("credit_customers.csv")  
  
# Initialize a label encoder  
le = encoder_instance()  
  
# Convert categorical features to numerical values    
credit_customers['credit_history'] = encode_column(le, credit_customers['credit_history'])  
credit_customers['employment'] = encode_column(le, credit_customers['employment'])  
credit_customers['class'] = encode_column(le, credit_customers['class'])  
 
print(credit_customers)
pickle.dump(credit_customers,open("./ref_result/credit_customers.pkl","wb"))


  